package gov.va.med.mhv.journal.converter;

import gov.va.med.mhv.journal.data.model.ActivityDetail;
import gov.va.med.mhv.journal.dto.ActivityDetailDTO;

import org.springframework.stereotype.Component;

@Component
public class ActivityDetailConverter {

	public ActivityDetailDTO convertDomainDetailItem(
			ActivityDetail activityDetail) {
		ActivityDetailDTO activityDetailDto = new ActivityDetailDTO();

		activityDetailDto.setActivityDetailId(activityDetail
				.getActivityDetailId());
		// activityDetailDto.setCreatedDate(activityDetail.getCreatedDate());
		activityDetailDto.setActivityType(activityDetail.getActivityType());
		activityDetailDto.setDescription(activityDetail.getDescription());
		if (activityDetail.getDistanceDuration() != null)
			activityDetailDto.setDistanceDuration(activityDetail.getDistanceDuration());
		activityDetailDto.setIntensity(activityDetail.getIntensity());
		activityDetailDto.setMeasure(activityDetail.getMeasure());
		if (activityDetail.getRepCount() != null)
			activityDetailDto.setRepCount(activityDetail.getRepCount());
		if (activityDetail.getSetCount() != null)
			activityDetailDto.setSetCount(activityDetail.getSetCount());
		activityDetailDto.setTimeOfDay(activityDetail.getTimeOfDay());
		activityDetailDto.setActivityJournalId(activityDetail
				.getActivityJournalId());

		return activityDetailDto;
	}

	public ActivityDetail convertDTODetailItem(
			ActivityDetailDTO activityDetailDto) {
		ActivityDetail activityDetail = new ActivityDetail();

		activityDetail.setActivityDetailId(activityDetailDto
				.getActivityDetailId());
		activityDetail.setActivityType(activityDetailDto.getActivityType());
		activityDetail.setDescription(activityDetailDto.getDescription());
		activityDetail.setDistanceDuration(activityDetailDto.getDistanceDuration());
		activityDetail.setIntensity(activityDetailDto.getIntensity());
		activityDetail.setMeasure(activityDetailDto.getMeasure());
		activityDetail.setRepCount(activityDetailDto.getRepCount());
		activityDetail.setSetCount(activityDetailDto.getSetCount());
		activityDetail.setTimeOfDay(activityDetailDto.getTimeOfDay());
		activityDetail.setActivityJournalId(activityDetailDto
				.getActivityJournalId());

		return activityDetail;
	}
}
